#include<p30fxxxx.h>
#include<ports.h>

/********************************************************************
* Function Name     : ConfigIntCN
* Description       : Enables/Disables the individual CN interrupts 
*                     and sets priority and enables/disables CN.
* Parameters        : None
* Return Value      : None
*********************************************************************/

void ConfigIntCN(long int config)
{
    IFS0bits.CNIF = 0;
    CNEN1 = (unsigned int)config;

#if defined(__dsPIC30F5011__) || defined(__dsPIC30F6011__) || defined(__dsPIC30F6012__) || \
    defined(__dsPIC30F5013__) || defined(__dsPIC30F6013__) || defined(__dsPIC30F6010__) || \
    defined(__dsPIC30F6014__) || defined(__dsPIC30F5015__)

    CNEN2 = (unsigned int)(config >> 16);

#endif

    config = config >> 24;
    IPC3bits.CNIP = config;
    IEC0bits.CNIE = config >> 3; 
}
/* end of function ConfigIntCN */
